<?php
include 'config.php';
include 'admin_header.php';

// Jumlah data
$total_berita = $conn->query("SELECT COUNT(*) FROM berita")->fetch_row()[0];
$total_ads = $conn->query("SELECT COUNT(*) FROM ads")->fetch_row()[0];
$ads_aktif = $conn->query("SELECT COUNT(*) FROM ads WHERE aktif=1")->fetch_row()[0];
?>
<div class="navbar">
    <button class="menu-btn" onclick="toggleMenu()"><i class="bi bi-list"></i></button>
    <h5>📊 Dashboard Admin</h5>
</div>

<div class="content">
    <div class="row g-3">
        <div class="col-md-4">
            <div class="card text-center p-4">
                <h4 class="text-primary"><i class="bi bi-newspaper"></i></h4>
                <h5><?= $total_berita ?></h5>
                <p class="text-muted">Total Berita</p>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card text-center p-4">
                <h4 class="text-success"><i class="bi bi-badge-ad"></i></h4>
                <h5><?= $total_ads ?></h5>
                <p class="text-muted">Total Iklan</p>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card text-center p-4">
                <h4 class="text-warning"><i class="bi bi-check2-circle"></i></h4>
                <h5><?= $ads_aktif ?></h5>
                <p class="text-muted">Iklan Aktif</p>
            </div>
        </div>
    </div>

    <div class="card mt-4 p-4">
        <h5>📅 Aktivitas Terbaru</h5>
        <table class="table table-striped mt-3">
            <thead>
                <tr>
                    <th>#</th>
                    <th>Judul</th>
                    <th>Tanggal</th>
                </tr>
            </thead>
            <tbody>
                <?php
                $res = $conn->query("SELECT judul, created_at FROM berita ORDER BY id DESC LIMIT 5");
                if ($res->num_rows > 0):
                    $no = 1;
                    while ($r = $res->fetch_assoc()):
                ?>
                <tr>
                    <td><?= $no++ ?></td>
                    <td><?= htmlspecialchars($r['judul']) ?></td>
                    <td><?= date('d M Y H:i', strtotime($r['created_at'])) ?></td>
                </tr>
                <?php endwhile; else: ?>
                    <tr><td colspan="3" class="text-center text-muted">Belum ada berita</td></tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>
