<?php
include 'config.php';
include 'admin_header.php'; // 🔗 Navigasi atas

// Tambah iklan
if (isset($_POST['tambah'])) {
    $nama = $_POST['nama'];
    $link = $_POST['ad_link'];
    $stmt = $conn->prepare("INSERT INTO ads (nama_iklan, ad_link) VALUES (?, ?)");
    $stmt->bind_param("ss", $nama, $link);
    $stmt->execute();
    $stmt->close();
    header("Location: admin_ads.php");
    exit;
}

// Update status aktif
if (isset($_POST['update_aktif'])) {
    $aktif_ids = $_POST['aktif'] ?? [];
    $conn->query("UPDATE ads SET aktif = 0");
    if (!empty($aktif_ids)) {
        $ids = implode(",", array_map('intval', $aktif_ids));
        $conn->query("UPDATE ads SET aktif = 1 WHERE id IN ($ids)");
    }
    header("Location: admin_ads.php");
    exit;
}

// Hapus iklan
if (isset($_GET['hapus'])) {
    $id = intval($_GET['hapus']);
    $conn->query("DELETE FROM ads WHERE id = $id");
    header("Location: admin_ads.php");
    exit;
}

$result = $conn->query("SELECT * FROM ads ORDER BY id DESC");
?>
<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title>Admin Kelola Iklan</title>
<style>
body {
    font-family: 'Segoe UI', sans-serif;
    background: #f5f7fa;
    margin: 0;
    padding: 0;
}
.container {
    max-width: 850px;
    margin: 25px auto;
    background: #fff;
    padding: 20px;
    border-radius: 12px;
    box-shadow: 0 3px 10px rgba(0,0,0,0.1);
}
h2 {
    text-align: center;
    color: #333;
    margin-bottom: 20px;
}
input[type=text], textarea {
    width: 100%;
    padding: 10px;
    border: 1px solid #ddd;
    border-radius: 8px;
    margin-bottom: 10px;
    font-size: 15px;
}
textarea {
    height: 100px;
    font-family: monospace;
}
button {
    background: #007bff;
    border: none;
    color: #fff;
    padding: 10px 14px;
    border-radius: 8px;
    cursor: pointer;
    font-size: 14px;
    transition: background 0.3s;
}
button:hover {
    background: #0056b3;
}
.scroll-area {
    max-height: 450px;
    overflow-y: auto;
    margin-top: 15px;
    border: 1px solid #eee;
    border-radius: 10px;
}
table {
    width: 100%;
    border-collapse: collapse;
}
th, td {
    padding: 10px;
    border-bottom: 1px solid #eee;
    text-align: left;
    font-size: 14px;
    vertical-align: top;
}
th {
    background: #f1f3f4;
    font-weight: 600;
}
.action-btn {
    background: #dc3545;
    padding: 6px 10px;
    border-radius: 6px;
    text-decoration: none;
    color: #fff;
    font-size: 13px;
}
.action-btn:hover {
    background: #b52b38;
}
.save-btn {
    background: #28a745;
    margin-top: 15px;
    width: 100%;
}
.save-btn:hover {
    background: #1e7e34;
}
.ad-preview {
    border: 1px dashed #ccc;
    padding: 5px;
    border-radius: 6px;
    background: #fafafa;
}
@media(max-width:600px) {
    th, td { font-size: 13px; padding: 8px; }
    .container { margin: 10px; padding: 15px; }
    button { width: 100%; }
}
</style>
</head>
<body>

<div class="container">
    <h2>📢 Kelola Iklan Adsterra</h2>

    <!-- Form Tambah Iklan -->
    <form method="POST">
        <input type="text" name="nama" placeholder="Nama Iklan (opsional)">
        <textarea name="ad_link" placeholder="Tempel link atau kode script/iframe iklan di sini..." required></textarea>
        <button type="submit" name="tambah">+ Tambah Iklan</button>
    </form>

    <!-- Daftar Iklan -->
    <form method="POST">
        <div class="scroll-area">
            <table>
                <tr>
                    <th style="width:60px;text-align:center;">Aktif</th>
                    <th style="width:150px;">Nama</th>
                    <th>Preview Iklan</th>
                    <th style="width:80px;">Aksi</th>
                </tr>
                <?php if ($result->num_rows > 0): ?>
                    <?php while($row = $result->fetch_assoc()): ?>
                        <tr>
                            <td style="text-align:center;">
                                <input type="checkbox" name="aktif[]" value="<?= $row['id'] ?>" <?= $row['aktif'] ? 'checked' : '' ?>>
                            </td>
                            <td><?= htmlspecialchars($row['nama_iklan'] ?: 'Iklan #'.$row['id']) ?></td>
                            <td class="ad-preview">
                                <?= $row['ad_link'] // tampilkan apa adanya agar iframe/script aktif ?>
                            </td>
                            <td>
                                <a href="?hapus=<?= $row['id'] ?>" class="action-btn" onclick="return confirm('Hapus iklan ini?')">Hapus</a>
                            </td>
                        </tr>
                    <?php endwhile; ?>
                <?php else: ?>
                    <tr><td colspan="4" style="text-align:center;color:#777;">Belum ada data iklan.</td></tr>
                <?php endif; ?>
            </table>
        </div>
        <button type="submit" name="update_aktif" class="save-btn">💾 Simpan Pilihan Iklan Aktif</button>
    </form>
</div>

</body>
</html>
