<?php
include 'config.php';

// Ambil data berita berdasarkan slug
$slug = $_GET['slug'] ?? '';
$stmt = $conn->prepare("SELECT * FROM berita WHERE slug = ?");
$stmt->bind_param("s", $slug);
$stmt->execute();
$data = $stmt->get_result()->fetch_assoc();
$stmt->close();

if (!$data) {
    die("<h3>Berita tidak ditemukan.</h3>");
}

// Ambil semua iklan aktif
$ads = $conn->query("SELECT * FROM ads WHERE aktif = 1 ORDER BY id ASC");

// Metadata
$judul = htmlspecialchars($data['judul'] ?? 'Berita');
$thumbnail = htmlspecialchars($data['thumbnail'] ?? '');
$link = trim($data['link'] ?? '#');

// --- 🔧 Fungsi ubah otomatis link YouTube jadi embed
function convertToEmbed($url) {
    // Format https://www.youtube.com/watch?v=xxxx
    if (strpos($url, 'youtube.com/watch?v=') !== false) {
        return str_replace('watch?v=', 'embed/', $url);
    }

    // Format https://youtu.be/xxxx
    if (strpos($url, 'youtu.be/') !== false) {
        return str_replace('youtu.be/', 'www.youtube.com/embed/', $url);
    }

    // Jika bukan YouTube, kembalikan aslinya
    return $url;
}

// URL dasar otomatis
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443)
    ? "https://" : "http://";
$baseUrl = $protocol . $_SERVER['HTTP_HOST'];
$currentUrl = $baseUrl . $_SERVER['REQUEST_URI'];
?>
<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title><?= $judul ?></title>

<!-- 🧠 Meta SEO -->
<meta property="og:title" content="<?= $judul ?>">
<meta property="og:description" content="Baca berita terbaru dan populer.">
<meta property="og:image" content="<?= $thumbnail ?>">
<meta property="og:url" content="<?= $currentUrl ?>">
<meta property="og:type" content="article">
<meta name="twitter:card" content="summary_large_image">
<meta name="twitter:title" content="<?= $judul ?>">
<meta name="twitter:description" content="Berita populer dari sumber terpercaya.">
<meta name="twitter:image" content="<?= $thumbnail ?>">

<style>
body {
    margin: 0;
    font-family: "Segoe UI", Arial, sans-serif;
    background: #f5f7fa;
    color: #333;
}

.header {
    text-align: center;
    background: #007bff;
    color: white;
    padding: 12px;
    font-size: 18px;
    font-weight: 600;
    box-shadow: 0 2px 5px rgba(0,0,0,0.1);
}

#content {
    width: 100%;
    height: 80vh;
    border: none;
    background: #fff;
    display: block;
}

.ads-container {
    display: flex;
    flex-direction: column;
    gap: 12px;
    background: #fff;
    padding: 12px;
    border-top: 1px solid #eee;
    box-shadow: 0 -2px 5px rgba(0,0,0,0.05);
}

.ad-box {
    border-radius: 8px;
    overflow: hidden;
    border: 1px solid #eee;
    background: #fafafa;
    text-align: center;
    padding: 5px;
}

.ad-box iframe {
    width: 100%;
    height: 160px;
    border: none;
    display: block;
}

@media (max-width: 768px) {
    #content { height: 70vh; }
    .ad-box iframe { height: 140px; }
}
</style>
</head>
<body>

<div class="header">📰 <?= $judul ?></div>

<!-- Frame Berita / YouTube -->
<iframe 
    id="content" 
    src="<?= htmlspecialchars(convertToEmbed($link)) ?>" 
    loading="lazy" 
    allowfullscreen>
</iframe>

<!-- Iklan Aktif -->
<?php if ($ads->num_rows > 0): ?>
<div class="ads-container">
    <?php while($ad = $ads->fetch_assoc()): ?>
        <div class="ad-box">
            <?php
            $adCode = trim($ad['ad_link']);

            // ✅ Jika input hanya URL, tampilkan via iframe
            if (
                filter_var($adCode, FILTER_VALIDATE_URL) &&
                stripos($adCode, '<script') === false &&
                stripos($adCode, '<iframe') === false
            ) {
                echo '<iframe src="' . htmlspecialchars($adCode) . '" loading="lazy"></iframe>';
            } 
            // ✅ Jika sudah berupa kode iklan (iframe/script), tampilkan langsung
            else {
                echo $adCode;
            }
            ?>
        </div>
    <?php endwhile; ?>
</div>
<?php endif; ?>

</body>
</html>
